function v = vechmd(x)
% PURPOSE: Creates a column vector by stacking elements of x that are
%          on and below the diagonal; each column is placed into a matrix.
%          Created because I could not get Mike Cliff's vech function to 
%          work on multidimensional matrices arrays.
% 
% *** adapted from Mike Cliff's vech function
%----------------------------------------------------------
% USAGE:  v = vech(x)
% where:  x = an input matrix
%         i1 is the 4th dimension of x
%         i2 is the 3rd dimension of x
%---------------------------------------------------------
% RETURNS:
%         v = output vector containing stacked columns of x
%----------------------------------------------------------

% Written by Monica Mow, Bank of Canada - mowm@bankofcanada.ca
% CREATED: Sept. 5, 2014

[n, k, m, p] = size(x);

v = [];
for i1=1:p
    
    for i2=1:m
        
        c = x(:,:,i2,i1);
        
        vechmd=c(tril(true(size(c))));
       
        v = [v vechmd];
        
    end
    
end